string GetDescription()
{
	return "Renders the melody into a track with simple accents";
}

void Render(RenderPart @p)
{
	double max_len = 0.25;
	
	for (int i = 0; i < p.GetEvents(); i++)
	{
		Time t = p.GetEventStart(i);
		
		int poz = t.m_Pos;
		
		
		
		if ((poz == 0 || poz == 2) && t.m_Pos - poz < 0.1)
		{
			// accent	
			
			p.AddNote(p.GetEventStart(i), p.GetEventEnd(i), p.GetEventPitch(i),RndInt(124,127));	
		}
		else
		{
			double len = (p.GetEventEnd(i).m_Bar - p.GetEventStart(i).m_Bar) * p.GetUniquePart().GetMetrum() + (p.GetEventEnd(i).m_Pos - p.GetEventStart(i).m_Pos);
			
			if (len > max_len)
			{
				p.AddNote(p.GetEventStart(i), CreateTime(p.GetEventStart(i).m_Bar, p.GetEventStart(i).m_Pos+max_len) , p.GetEventPitch(i),RndInt(85, 105));	
			}
			else p.AddNote(p.GetEventStart(i), p.GetEventEnd(i), p.GetEventPitch(i),RndInt(85, 105));	
			
		}
		
	}
}